<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Listing;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ListingController extends Controller
{
    public function index()
    {
        $listings = Listing::latest()->paginate(10);
        return view('admin.listing.index', compact('listings'));
    }

    public function create()
    {
        return view('admin.listing.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'url' => 'nullable|string',
            'sample_post_link' => 'nullable|string',
            'category' => 'required',
            'link_type' => 'required',
            'da' => 'required|integer',
            'dr' => 'required|integer',
            'traffic' => 'required',
            'spam_score' => 'nullable',
            'description' => 'nullable|string',
            'price' => 'required|numeric',
        ]);

        $data = $request->all();
        $data['slug'] = Listing::generateUniqueSlug($request->input('title'));

        Listing::create($data);

        return redirect()->route('admin.listings.index')->with('success', 'Listing created successfully.');
    }

    public function edit(Listing $listing)
    {
        return view('admin.listing.edit', compact('listing'));
    }

    public function update(Request $request, Listing $listing)
    {
        $request->validate([
            'title' => 'required',
            'url' => 'nullable|string',
            'sample_post_link' => 'nullable|string',
            'category' => 'required',
            'link_type' => 'required',
            'da' => 'required|integer',
            'dr' => 'required|integer',
            'traffic' => 'required',
            'spam_score' => 'nullable',
            'description' => 'nullable|string',
            'price' => 'required|numeric',
        ]);

        $data = $request->all();

        if ($listing->title !== $request->input('title')) {
            $data['slug'] = Listing::generateUniqueSlug($request->input('title'), $listing->id);
        }

        $listing->update($data);

        return redirect()->route('admin.listings.index')->with('success', 'Listing updated successfully.');
    }

    public function destroy(Listing $listing)
    {
        $listing->delete();
        return redirect()->route('admin.listings.index')->with('success', 'Listing deleted successfully.');
    }
}
