<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use Illuminate\Http\Request;

class showBlogController extends Controller
{
    // All blogs with pagination
    public function index(Request $request)
    {
        $query = Blog::latest();

        if ($request->has('tag')) {
            $tag = $request->tag;
            $query->where('tags', 'LIKE', '%' . $tag . '%');
        }

        $blogs = $query->paginate(6); // 6 blogs per page

        // Fetch popular tags
        $allTags = Blog::whereNotNull('tags')->pluck('tags')->toArray();
        $tagCounts = [];
        foreach ($allTags as $tagString) {
            $tags = array_map('trim', explode(',', $tagString));
            foreach ($tags as $tag) {
                if ($tag) {
                    $tagCounts[$tag] = ($tagCounts[$tag] ?? 0) + 1;
                }
            }
        }
        arsort($tagCounts);
        $popularTags = array_keys(array_slice($tagCounts, 0, 10)); // Top 10 tags

        return view('pages.blog', compact('blogs', 'popularTags'));
    }

    // Single blog
    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)->firstOrFail();

        // Fetch popular tags
        $allTags = Blog::whereNotNull('tags')->pluck('tags')->toArray();
        $tagCounts = [];
        foreach ($allTags as $tagString) {
            $tags = array_map('trim', explode(',', $tagString));
            foreach ($tags as $tag) {
                if ($tag) {
                    $tagCounts[$tag] = ($tagCounts[$tag] ?? 0) + 1;
                }
            }
        }
        arsort($tagCounts);
        $popularTags = array_keys(array_slice($tagCounts, 0, 10)); // Top 10 tags

        return view('pages.blog-details', compact('blog', 'popularTags'));
    }
}
