<?php
namespace App\Mail;

use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Contact;
use Illuminate\Contracts\Queue\ShouldQueue;

class ContactMessageMail extends Mailable implements ShouldQueue
{
    use SerializesModels;

    public $contact;

    public function __construct(Contact $contact)
    {
        $this->contact = $contact;
    }

    public function build()
    {
        return $this->subject('New Contact Message')
                    ->view('emails.contact-message');
    }
}
