@extends('admin.layout')

@section('content')
<div class="mb-8">
    <a href="{{ route('admin.orders.index') }}" class="inline-flex items-center text-sm font-medium text-gray-500 hover:text-indigo-600 transition-colors mb-4">
        <i class="fa-solid fa-arrow-left mr-2"></i> Back to Orders
    </a>
    <h1 class="text-3xl font-bold text-gray-900">Order Details</h1>
    <p class="text-gray-600 mt-1">Order #RF-{{ str_pad($order->id, 5, '0', STR_PAD_LEFT) }}</p>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Left: Order Info -->
    <div class="lg:col-span-2 space-y-6">
        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-circle-info mr-3 text-indigo-500"></i>
                Customer Selection
            </h2>
            <div class="grid grid-cols-2 gap-6">
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Service Type</p>
                    <p class="text-sm font-bold text-gray-900 uppercase">{{ $order->service_type }}</p>
                </div>
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Plan Name</p>
                    <p class="text-sm font-bold text-gray-900">{{ $order->plan_name }}</p>
                </div>
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Target URL</p>
                    <a href="{{ $order->target_url }}" target="_blank" class="text-sm font-bold text-indigo-600 hover:underline">
                        {{ $order->target_url }} <i class="fa-solid fa-external-link text-xs ml-1"></i>
                    </a>
                </div>
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Topic / Anchor</p>
                    <p class="text-sm font-bold text-gray-900">{{ $order->topic }}</p>
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-user mr-3 text-indigo-500"></i>
                Contact Information
            </h2>
            <div class="grid grid-cols-2 gap-6">
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Email address</p>
                    <p class="text-sm font-bold text-gray-900">{{ $order->customer_email }}</p>
                </div>
                <div>
                    <p class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">whatsapp number</p>
                    <p class="text-sm font-bold text-gray-900">{{ $order->whatsapp_number ?? 'Not provided' }}</p>
                </div>
            </div>
        </div>

        @if($order->article_file)
        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-file-lines mr-3 text-indigo-500"></i>
                Attached File
            </h2>
            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-xl">
                <div class="flex items-center">
                    <i class="fa-solid fa-file-arrow-down text-3xl text-gray-400 mr-4"></i>
                    <div>
                        <p class="text-sm font-bold text-gray-900">Instruction/Article File</p>
                        <p class="text-xs text-gray-500">Download to view details</p>
                    </div>
                </div>
                <a href="{{ asset('storage/' . $order->article_file) }}" download class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition-all font-semibold text-sm">
                    Download File
                </a>
            </div>
        </div>
        @endif
    </div>

    <!-- Right: Status Update -->
    <div class="space-y-6">
        <div class="glass rounded-2xl p-6 shadow-sm border border-gray-200">
            <h2 class="text-lg font-bold text-gray-900 mb-4">Manage Order</h2>
            <form action="{{ route('admin.orders.update', $order->id) }}" method="POST" class="space-y-4">
                @csrf
                @method('PUT')
                
                <div>
                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Order Status</label>
                    <select name="order_status" class="w-full px-4 py-2 rounded-lg border border-gray-200 focus:border-indigo-500 outline-none bg-white text-sm">
                        <option value="new" {{ $order->order_status == 'new' ? 'selected' : '' }}>New</option>
                        <option value="processing" {{ $order->order_status == 'processing' ? 'selected' : '' }}>Processing</option>
                        <option value="completed" {{ $order->order_status == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="cancelled" {{ $order->order_status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>

                <div>
                    <label class="block text-xs font-semibold text-gray-500 uppercase tracking-wider mb-1">Payment Status</label>
                    <select name="payment_status" class="w-full px-4 py-2 rounded-lg border border-gray-200 focus:border-indigo-500 outline-none bg-white text-sm">
                        <option value="pending" {{ $order->payment_status == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="completed" {{ $order->payment_status == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="failed" {{ $order->payment_status == 'failed' ? 'selected' : '' }}>Failed</option>
                        <option value="refunded" {{ $order->payment_status == 'refunded' ? 'selected' : '' }}>Refunded</option>
                    </select>
                </div>

                <div class="pt-2">
                    <p class="text-xl font-bold text-indigo-600 mb-4">Total: ${{ number_format($order->price, 0) }}</p>
                    <button type="submit" class="w-full py-3 bg-indigo-600 text-white rounded-xl hover:bg-indigo-700 transition-all font-bold shadow-lg shadow-indigo-100">
                        Update Order
                    </button>
                </div>
            </form>
        </div>

        <div class="glass rounded-2xl p-6 shadow-sm border border-gray-200 bg-gray-50">
            <h3 class="text-sm font-bold text-gray-900 mb-2">Order Activity</h3>
            <p class="text-xs text-gray-500">Placed on: {{ $order->created_at->format('F d, Y \a\t h:i A') }}</p>
            <p class="text-xs text-gray-500 mt-1">Last update: {{ $order->updated_at->format('F d, Y \a\t h:i A') }}</p>
        </div>
    </div>
</div>
@endsection
