@include('layouts.header')
@include('layouts.navbar')

<div class="breadcumb-wrapper" data-bg-src="{{ asset('assets/img/bg/breadcumb-bg.jpg') }}">
    <div class="container">
        <div class="breadcumb-content">
            <h1 class="breadcumb-title">{{ $blog->title }}</h1>
            <ul class="breadcumb-menu">
                <li><a href="{{ route('home') }}">Home</a></li>
                <li><a href="{{ route('blog') }}">Blog</a></li>
                <li>Details</li>
            </ul>
        </div>
    </div>
</div>

<section class="th-blog-wrapper blog-details space-top space-extra-bottom">
    <div class="container">
        <div class="row">
            <div class="col-xxl-8 col-lg-7">
                <div class="th-blog blog-single">
                    @if($blog->image)
                    <div class="blog-img">
                        <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}" style="width: 100%; border-radius: 20px;">
                    </div>
                    @endif
                    <div class="blog-content">
                        <div class="blog-meta">
                            <a href="#"><i class="fa-regular fa-calendar"></i>{{ $blog->created_at->format('M d, Y') }}</a>
                            <a href="#"><i class="fa-regular fa-clock"></i>{{ ceil(str_word_count(strip_tags($blog->content)) / 200) }} min read</a>
                            <a href="#"><i class="fa-light fa-tags"></i> 
                                @if($blog->tags)
                                    @php
                                        $blogTags = array_map('trim', explode(',', $blog->tags));
                                    @endphp
                                    {{ implode(', ', array_slice($blogTags, 0, 2)) }}
                                @else
                                    SEO & Link Building
                                @endif
                            </a>
                        </div>
                        <h2 class="blog-title">{{ $blog->title }}</h2>
                        <div class="blog-text mt-4">
                            {!! $blog->content !!}
                        </div>
                    </div>
                    @if($blog->tags)
                    <div class="share-links clearfix">
                        <div class="row justify-content-between">
                            <div class="col-sm-auto">
                                <span class="share-links-title">Tags:</span>
                                <div class="tagcloud">
                                    @foreach(array_map('trim', explode(',', $blog->tags)) as $tag)
                                        <a href="{{ route('blog') }}?tag={{ urlencode($tag) }}">{{ $tag }}</a>
                                    @endforeach
                                </div>
                            </div>
                            <div class="col-sm-auto text-xl-end">
                                <span class="share-links-title">Share:</span>
                                <ul class="social-links">
                                    <li><a href="https://facebook.com/" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                                    <li><a href="https://twitter.com/" target="_blank"><i class="fab fa-twitter"></i></a></li>
                                    <li><a href="https://linkedin.com/" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            
            <div class="col-xxl-4 col-lg-5">
                <aside class="sidebar-area">
                    <div class="widget">
                        <h3 class="widget_title">Recent Posts</h3>
                        <div class="recent-post-wrap">
                            @foreach(\App\Models\Blog::where('id', '!=', $blog->id)->latest()->take(3)->get() as $recent)
                            <div class="recent-post">
                                @if($recent->image)
                                <div class="media-img">
                                    <a href="{{ route('user.blog.show', $recent->slug) }}">
                                        <img src="{{ asset($recent->image) }}" alt="{{ $recent->title }}">
                                    </a>
                                </div>
                                @endif
                                <div class="media-body">
                                    <div class="recent-post-meta">
                                        <a href="#"><i class="fa-sharp fa-solid fa-calendar-days"></i>{{ $recent->created_at->format('d M, Y') }}</a>
                                    </div>
                                    <h4 class="post-title">
                                        <a class="text-inherit" href="{{ route('user.blog.show', $recent->slug) }}">{{ Str::limit($recent->title, 40) }}</a>
                                    </h4>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="widget widget_tag_cloud">
                        <h3 class="widget_title">Popular Tags</h3>
                        <div class="tagcloud">
                            @forelse($popularTags as $tag)
                                <a href="{{ route('blog') }}?tag={{ urlencode($tag) }}">{{ $tag }}</a>
                            @empty
                                <a href="#">SEO Marketing</a>
                                <a href="#">Design</a>
                                <a href="#">Link Building</a>
                            @endforelse
                        </div>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

@include('layouts.footer')