<p class="mb-20 text-center text-muted" id="guestListingCount">{{ $listings->total() }} listings found</p>
<div class="table-responsive">
    <table id="guestListingTable" class="table table-hover align-middle">
        <thead>
            <tr>
                <th>Website Title</th>
                <th>Category</th>
                <th>Domain Authority</th>
                <th>Domain Rating</th>
                <th>Monthly Traffic</th>
                <th>Spam Score</th>
                <th>Link Type</th>
                <th>Price</th>
                <th class="text-end">Action</th>
            </tr>
        </thead>
        <tbody>
            @forelse($listings as $listing)
            <tr>
                <td>
                    <a href="{{ route('product.show', $listing->slug) }}" target="_blank" rel="noopener">
                        {{ $listing->title }} <span class="ms-1"><i
                                class="fa-regular fa-arrow-up-right"></i></span>
                    </a>
                </td>
                <td>{{ $listing->category }}</td>
                <td>{{ $listing->da }}</td>
                <td>{{ $listing->dr }}</td>
                <td>{{ $listing->traffic }}</td>
                <td>{{ $listing->spam_score ?? 'N/A' }}</td>
                <td>{{ $listing->link_type }}</td>
                <td>
                    @if($listing->original_price)
                        <span class="text-muted text-decoration-line-through me-1">$ {{ number_format($listing->original_price, 0) }}</span>
                    @endif
                    <span>$ {{ number_format($listing->price, 0) }}</span>
                </td>
                <td class="text-end">
                    <a href="{{ route('product.show', $listing->slug) }}" class="th-btn th-radius">Buy Now</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="9" class="text-center">No listings found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>
<div class="row align-items-center mt-3 gy-2">
    <div class="col-md-6 text-center text-md-start">
        <small class="text-muted">
            Showing {{ $listings->firstItem() }} to {{ $listings->lastItem() }} of {{ $listings->total() }} entries
        </small>
    </div>
    <div class="col-md-6">
        <div class="laravel-pagination-wrapper d-flex justify-content-center justify-content-md-end">
            {{ $listings->links('vendor.pagination.custom') }}
        </div>
    </div>
</div>
