@if ($paginator->hasPages())
    <div class="d-flex justify-content-center justify-content-md-end gap-1 flex-wrap">
        {{-- First Page Link --}}
        @if ($paginator->onFirstPage())
            <button type="button" class="btn btn-sm btn-outline-secondary" disabled>First</button>
        @else
            <a href="{{ $paginator->url(1) }}" class="btn btn-sm btn-outline-secondary">First</a>
        @endif

        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <button type="button" class="btn btn-sm btn-outline-secondary" disabled>Previous</button>
        @else
            <a href="{{ $paginator->previousPageUrl() }}" class="btn btn-sm btn-outline-secondary" rel="prev">Previous</a>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <span class="px-1">{{ $element }}</span>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <button type="button" class="btn btn-sm btn-theme">{{ $page }}</button>
                    @else
                        <a href="{{ $url }}" class="btn btn-sm btn-outline-secondary">{{ $page }}</a>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <a href="{{ $paginator->nextPageUrl() }}" class="btn btn-sm btn-outline-secondary" rel="next">Next</a>
        @else
            <button type="button" class="btn btn-sm btn-outline-secondary" disabled>Next</button>
        @endif

        {{-- Last Page Link --}}
        @if ($paginator->hasMorePages())
            <a href="{{ $paginator->url($paginator->lastPage()) }}" class="btn btn-sm btn-outline-secondary">Last</a>
        @else
            <button type="button" class="btn btn-sm btn-outline-secondary" disabled>Last</button>
        @endif
    </div>
@endif
