<p class="mb-20 text-center text-muted" id="guestListingCount"><?php echo e($listings->total()); ?> listings found</p>
<div class="table-responsive">
    <table id="guestListingTable" class="table table-hover align-middle">
        <thead>
            <tr>
                <th>Website Title</th>
                <th>Category</th>
                <th>Domain Authority</th>
                <th>Domain Rating</th>
                <th>Monthly Traffic</th>
                <th>Spam Score</th>
                <th>Link Type</th>
                <th>Price</th>
                <th class="text-end">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $listings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $listing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td>
                    <a href="<?php echo e(route('product.show', $listing->slug)); ?>" target="_blank" rel="noopener">
                        <?php echo e($listing->title); ?> <span class="ms-1"><i
                                class="fa-regular fa-arrow-up-right"></i></span>
                    </a>
                </td>
                <td><?php echo e($listing->category); ?></td>
                <td><?php echo e($listing->da); ?></td>
                <td><?php echo e($listing->dr); ?></td>
                <td><?php echo e($listing->traffic); ?></td>
                <td><?php echo e($listing->spam_score ?? 'N/A'); ?></td>
                <td><?php echo e($listing->link_type); ?></td>
                <td>
                    <?php if($listing->original_price): ?>
                        <span class="text-muted text-decoration-line-through me-1">$ <?php echo e(number_format($listing->original_price, 0)); ?></span>
                    <?php endif; ?>
                    <span>$ <?php echo e(number_format($listing->price, 0)); ?></span>
                </td>
                <td class="text-end">
                    <a href="<?php echo e(route('product.show', $listing->slug)); ?>" class="th-btn th-radius">Buy Now</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="9" class="text-center">No listings found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<div class="row align-items-center mt-3 gy-2">
    <div class="col-md-6 text-center text-md-start">
        <small class="text-muted">
            Showing <?php echo e($listings->firstItem()); ?> to <?php echo e($listings->lastItem()); ?> of <?php echo e($listings->total()); ?> entries
        </small>
    </div>
    <div class="col-md-6">
        <div class="laravel-pagination-wrapper d-flex justify-content-center justify-content-md-end">
            <?php echo e($listings->links('vendor.pagination.custom')); ?>

        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\Rank-fetch\resources\views/partials/guest-post-list.blade.php ENDPATH**/ ?>