

<?php $__env->startSection('content'); ?>
<!-- Success/Error Messages -->
<?php if(session('success')): ?>
<div class="mb-6 bg-green-50 border border-green-200 text-green-800 px-6 py-4 rounded-xl flex items-center justify-between">
    <div class="flex items-center">
        <i class="fa-solid fa-check-circle text-green-500 text-xl mr-3"></i>
        <span class="font-medium"><?php echo e(session('success')); ?></span>
    </div>
    <button onclick="this.parentElement.remove()" class="text-green-600 hover:text-green-800">
        <i class="fa-solid fa-times"></i>
    </button>
</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="mb-6 bg-red-50 border border-red-200 text-red-800 px-6 py-4 rounded-xl flex items-center justify-between">
    <div class="flex items-center">
        <i class="fa-solid fa-exclamation-circle text-red-500 text-xl mr-3"></i>
        <span class="font-medium"><?php echo e(session('error')); ?></span>
    </div>
    <button onclick="this.parentElement.remove()" class="text-red-600 hover:text-red-800">
        <i class="fa-solid fa-times"></i>
    </button>
</div>
<?php endif; ?>

<div class="mb-8 flex justify-between items-center">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Contact Messages</h1>
        <p class="text-gray-500">Manage and respond to user inquiries from your website.</p>
    </div>
</div>

<div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full text-left">
            <thead>
                <tr class="bg-gray-50 text-gray-500 text-xs uppercase tracking-wider">
                    <th class="px-6 py-4 font-semibold">Name</th>
                    <th class="px-6 py-4 font-semibold">Email</th>
                    <th class="px-6 py-4 font-semibold">Subject</th>
                    <th class="px-6 py-4 font-semibold">Status</th>
                    <th class="px-6 py-4 font-semibold text-right">Date</th>
                    <th class="px-6 py-4 font-semibold text-center">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-6 py-4">
                        <div class="font-medium text-gray-900"><?php echo e($msg->first_name); ?> <?php echo e($msg->last_name); ?></div>
                    </td>
                    <td class="px-6 py-4 text-gray-600"><?php echo e($msg->email); ?></td>
                    <td class="px-6 py-4 text-gray-600"><?php echo e($msg->subject); ?></td>
                    <td class="px-6 py-4">
                        <?php if($msg->status === 'completed'): ?>
                            <span class="px-3 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-700">
                                <i class="fa-solid fa-check-circle"></i> Completed
                            </span>
                        <?php else: ?>
                            <span class="px-3 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-700">
                                <i class="fa-solid fa-clock"></i> Pending
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 text-right text-gray-500 text-sm"><?php echo e($msg->created_at->format('M d, Y')); ?></td>
                    <td class="px-6 py-4 text-center space-x-2">
                        <button onclick="viewMessage('<?php echo e($msg->first_name); ?> <?php echo e($msg->last_name); ?>', '<?php echo e($msg->email); ?>', '<?php echo e($msg->subject); ?>', '<?php echo e(addslashes(str_replace(["\r", "\n"], ' ', $msg->message))); ?>', <?php echo e($msg->id); ?>, '<?php echo e($msg->status); ?>')" class="text-indigo-500 hover:text-indigo-700 transition-colors">
                            <i class="fa-solid fa-eye"></i>
                        </button>
                        <?php if($msg->status === 'pending'): ?>
                        <button onclick="showReplyModal(<?php echo e($msg->id); ?>, '<?php echo e($msg->first_name); ?> <?php echo e($msg->last_name); ?>', '<?php echo e($msg->email); ?>')" class="text-blue-500 hover:text-blue-700 transition-colors" title="Reply">
                            <i class="fa-solid fa-reply"></i>
                        </button>
                        <form action="<?php echo e(route('admin.messages.complete', $msg->id)); ?>" method="POST" class="inline" title="Mark as Completed">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <button type="submit" class="text-green-500 hover:text-green-700 transition-colors">
                                <i class="fa-solid fa-check"></i>
                            </button>
                        </form>
                        <?php endif; ?>
                        <form action="<?php echo e(route('admin.messages.destroy', $msg->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this message?');" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-500 hover:text-red-700 transition-colors">
                                <i class="fa-solid fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-10 text-center text-gray-500">
                        No messages found.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($messages->hasPages()): ?>
    <div class="p-6 border-t border-gray-100">
        <?php echo e($messages->links()); ?>

    </div>
    <?php endif; ?>
</div>

<!-- Message View Modal -->
<div id="messageModal" class="fixed inset-0 z-50 flex items-center justify-center hidden">
    <div class="fixed inset-0 bg-gray-900/50 backdrop-blur-sm" onclick="closeModal()"></div>
    <div class="bg-white rounded-2xl shadow-xl z-10 w-full max-w-lg mx-4 overflow-hidden relative">
        <div class="p-6 border-b border-gray-100 flex items-center justify-between">
            <h3 class="text-xl font-bold text-gray-900">Contact Message</h3>
            <button onclick="closeModal()" class="text-gray-400 hover:text-gray-600 transition-colors">
                <i class="fa-solid fa-times text-xl"></i>
            </button>
        </div>
        <div class="p-6 space-y-4">
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">From</p>
                <p id="modalName" class="text-gray-900 font-medium"></p>
                <p id="modalEmail" class="text-sm text-indigo-600"></p>
            </div>
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Subject</p>
                <p id="modalSubject" class="text-gray-900"></p>
            </div>
            <div>
                <p class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Message</p>
                <div class="mt-1 p-4 bg-gray-50 rounded-xl text-gray-700 whitespace-pre-wrap max-h-60 overflow-y-auto" id="modalMessage"></div>
            </div>
        </div>
        <div class="p-6 border-t border-gray-100 flex justify-end">
            <button onclick="closeModal()" class="px-6 py-2 bg-gray-100 text-gray-700 font-semibold rounded-xl hover:bg-gray-200 transition-colors">Close</button>
        </div>
    </div>
</div>

<!-- Reply Modal -->
<div id="replyModal" class="fixed inset-0 z-50 flex items-center justify-center hidden">
    <div class="fixed inset-0 bg-gray-900/50 backdrop-blur-sm" onclick="closeReplyModal()"></div>
    <div class="bg-white rounded-2xl shadow-xl z-10 w-full max-w-2xl mx-4 overflow-hidden relative">
        <div class="p-6 border-b border-gray-100 flex items-center justify-between">
            <div>
                <h3 class="text-xl font-bold text-gray-900">Reply to Message</h3>
                <p class="text-sm text-gray-500 mt-1">Send a reply to <span id="replyUserName" class="font-semibold"></span></p>
            </div>
            <button onclick="closeReplyModal()" class="text-gray-400 hover:text-gray-600 transition-colors">
                <i class="fa-solid fa-times text-xl"></i>
            </button>
        </div>
        <form id="replyForm" method="POST">
            <?php echo csrf_field(); ?>
            <div class="p-6 space-y-4">
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Recipient Email</label>
                    <input type="email" id="replyUserEmail" readonly class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl text-gray-600" />
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Your Reply <span class="text-red-500">*</span></label>
                    <textarea name="reply_message" rows="8" required class="w-full px-4 py-3 border border-gray-200 rounded-xl focus:ring-2 focus:ring-indigo-500 focus:border-transparent resize-none" placeholder="Type your reply here..."></textarea>
                    <p class="text-xs text-gray-500 mt-2">This message will be sent to the user's email and the status will be marked as completed.</p>
                </div>
            </div>
            <div class="p-6 border-t border-gray-100 flex justify-end space-x-3">
                <button type="button" onclick="closeReplyModal()" class="px-6 py-2 bg-gray-100 text-gray-700 font-semibold rounded-xl hover:bg-gray-200 transition-colors">Cancel</button>
                <button type="submit" class="px-6 py-2 bg-indigo-600 text-white font-semibold rounded-xl hover:bg-indigo-700 transition-colors">
                    <i class="fa-solid fa-paper-plane mr-2"></i>Send Reply
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    function viewMessage(name, email, subject, message, id, status) {
        document.getElementById('modalName').textContent = name;
        document.getElementById('modalEmail').textContent = email;
        document.getElementById('modalSubject').textContent = subject;
        document.getElementById('modalMessage').textContent = message;
        document.getElementById('messageModal').classList.remove('hidden');
    }

    function closeModal() {
        document.getElementById('messageModal').classList.add('hidden');
    }

    function showReplyModal(messageId, userName, userEmail) {
        document.getElementById('replyUserName').textContent = userName;
        document.getElementById('replyUserEmail').value = userEmail;
        document.getElementById('replyForm').action = `/admin/messages/${messageId}/reply`;
        document.getElementById('replyModal').classList.remove('hidden');
    }

    function closeReplyModal() {
        document.getElementById('replyModal').classList.add('hidden');
        document.getElementById('replyForm').reset();
    }
</script>

<style>
    /* Pagination Styling */
    .pagination {
        display: flex;
        justify-content: center;
        gap: 0.5rem;
    }
    .page-item .page-link {
        padding: 0.5rem 1rem;
        border-radius: 0.5rem;
        background: white;
        border: 1px solid #e5e7eb;
        color: #374151;
    }
    .page-item.active .page-link {
        background: #6366f1;
        color: white;
        border-color: #6366f1;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\admin\messages\index.blade.php ENDPATH**/ ?>