<?php $__env->startSection('title', 'Order Details | RankFetch'); ?>

<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<style>
    :root {
        --rf-teal: #47c1d8;
        --rf-dark: #1e1b4b;
        --rf-purple: #7D55A6;
    }
    .order-form-area {
        background-color: #f8fafc;
        padding-bottom: 80px;
    }
    .form-card {
        background: #fff;
        border-radius: 24px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        border: 1px solid #f1f5f9;
        max-width: 600px;
        margin: 0 auto;
        overflow: hidden;
    }
    .service-badge {
        display: inline-block;
        padding: 6px 14px;
        background: rgba(71, 193, 216, 0.1);
        color: var(--rf-teal);
        border-radius: 30px;
        font-size: 12px;
        font-weight: 700;
        text-transform: uppercase;
        margin-bottom: 20px;
    }
    .form-label {
        font-weight: 600;
        color: var(--rf-dark);
        font-size: 14px;
        margin-bottom: 8px;
    }
    .form-control-custom {
        display: block;
        width: 100%;
        padding: 12px 16px;
        font-size: 14px;
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        background-color: #f8fafc;
    }
    .form-control-custom:focus {
        border-color: var(--rf-teal);
        outline: 0;
        background-color: #fff;
    }
    .btn-submit-order {
        width: 100%;
        background: var(--rf-teal);
        color: #fff;
        border: none;
        padding: 16px;
        border-radius: 12px;
        font-weight: 700;
        font-size: 16px;
        margin-top: 20px;
        transition: all 0.3s;
    }
    .btn-submit-order:hover {
        background: #38b0c5;
        transform: translateY(-2px);
    }
    
    .checkout-footer-alt {
        background: #1e1b4b;
        border-radius: 20px;
        padding: 25px;
        margin-top: 30px;
        text-align: center;
    }
    .paypal-badge-text-alt {
        color: #94a3b8;
        font-size: 10px;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        display: block;
        margin-bottom: 12px;
    }
    .paypal-btn-mock-alt {
        background: #ffc439;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 12px;
        cursor: pointer;
        transition: transform 0.2s;
        border: none;
        width: 100%;
    }
    .paypal-btn-mock-alt:hover {
        transform: scale(1.02);
    }
    .price-display-alt {
        color: #fff;
        margin-bottom: 20px;
    }
    .price-total-lbl-alt {
        color: #94a3b8;
        font-size: 13px;
        display: block;
        margin-bottom: 5px;
    }
    .price-amount-alt {
        font-size: 28px;
        font-weight: 700;
    }

    .payment-success-banner {
        background: #ecfdf5;
        border: 1px solid #10b981;
        border-radius: 12px;
        padding: 15px;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        gap: 12px;
    }
    .success-icon {
        width: 30px;
        height: 30px;
        background: #10b981;
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        flex-shrink: 0;
    }
</style>

<div class="order-form-area">
    <div class="space container">
        <div class="form-card">
            <?php if(isset($isPaid) && $isPaid): ?>
                <div class="payment-success-banner">
                    <div class="success-icon">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <div>
                        <h4 class="h6 fw-bold mb-0" style="color: #064e3b;">Payment Successful!</h4>
                        <p class="small mb-0" style="color: #065f46;">Please fill in the project details below to complete your order.</p>
                    </div>
                </div>
            <?php endif; ?>

            <div class="text-center">
                <span class="service-badge"><?php echo e($service); ?> service</span>
                <h1 class="h3 fw-bold mb-2">
                    <?php echo e(isset($isPaid) && $isPaid ? 'Final Step: Add Your Details' : $plan); ?>

                </h1>
                <p class="text-muted small">Provide the necessary details for your guest post placement.</p>
            </div>

            <form action="<?php echo e(route('service.order.process')); ?>" method="POST" enctype="multipart/form-data" class="mt-4">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="service_type" value="<?php echo e($service); ?>">
                <input type="hidden" name="plan_name" value="<?php echo e($plan); ?>">
                <input type="hidden" name="price" value="<?php echo e($price); ?>">
                <?php if(isset($isPaid) && $isPaid): ?>
                    <input type="hidden" name="payment_status" value="completed">
                <?php endif; ?>

                <div class="mb-3">
                    <label class="form-label">Email Address</label>
                    <input type="email" name="customer_email" class="form-control-custom" placeholder="your@email.com" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Target Website URL</label>
                    <input type="url" name="target_url" class="form-control-custom" placeholder="https://yourwebsite.com" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Anchor Text / Topic</label>
                    <input type="text" name="topic" class="form-control-custom" placeholder="e.g. Best SEO Service" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">WhatsApp Number (Optional)</label>
                    <input type="text" name="whatsapp_number" class="form-control-custom" placeholder="+123 456 7890">
                </div>

                <div class="mb-4">
                    <label class="form-label">Instructions / File (Optional)</label>
                    <input type="file" name="article_file" class="form-control-custom">
                    <small class="text-muted">PDF, Word, or TXT (Max 5MB)</small>
                </div>

                <button type="submit" class="btn-submit-order">
                   <?php echo e(isset($isPaid) && $isPaid ? 'Complete Order' : 'Submit Details & Proceed to Payment'); ?> <i class="fa-regular fa-arrow-right ms-2"></i>
                </button>
            </form>

            <?php if(!isset($isPaid) || !$isPaid): ?>
            <div class="checkout-footer-alt">
                <div class="price-display-alt">
                    <span class="price-total-lbl-alt">Total Price:</span>
                    <span class="price-amount-alt">$<?php echo e(number_format($price, 0)); ?></span>
                </div>
                
                <span class="paypal-badge-text-alt">Pay first, add details later</span>
                <div class="paypal-btn-mock-alt" onclick="handlePayFirst()">
                    <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/PP_logo_h_100x26.png" alt="PayPal">
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
    function handlePayFirst() {
        if(confirm('Simulating PayPal Payment... Click OK to complete payment and add details.')) {
            // Redirect back with status=paid
            const urlParams = new URLSearchParams(window.location.search);
            urlParams.set('status', 'paid');
            window.location.search = urlParams.toString();
        }
    }
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH C:\xampp\htdocs\Rank-fetch\resources\views/pages/service-order-form.blade.php ENDPATH**/ ?>