<?php $__env->startSection('title', $listing->title . ' | Guest Post Opportunity | RankFetch'); ?>
<?php $__env->startSection('meta_description', 'Buy high-quality guest post backlink on ' . $listing->title . ' with DA ' . $listing->da . ', DR ' . $listing->dr . ' and ' . $listing->traffic . ' monthly traffic.'); ?>

<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<style>
    :root {
        --rf-teal: #47c1d8;
        --rf-dark: #12102e;
        --rf-text-muted: #64748b;
    }

    .product-details-area {
        background-color: #ffffff;
        /* padding: 40px 0 80px 0; */
        font-family: 'DM Sans', sans-serif;
    }
    
    .breadcrumb-custom {
        font-size: 13px;
        color: #64748b;
        margin-bottom: 20px;
    }
    
    .breadcrumb-custom a {
        color: var(--rf-teal);
        text-decoration: none;
    }
    
    .breadcrumb-separator {
        margin: 0 8px;
        color: #cbd5e1;
    }

    .site-title {
        font-size: 32px;
        font-weight: 700;
        color: #1a202c;
        margin-bottom: 30px;
    }

    .metrics-row {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        margin-bottom: 40px;
    }

    .metric-item {
        background: #f4f7fa;
        border-radius: 12px;
        padding: 20px 12px;
        min-width: 100px;
        text-align: center;
        flex: 1;
    }

    .metric-val {
        display: block;
        font-size: 20px;
        font-weight: 700;
        color: #7D55A6;
        margin-bottom: 4px;
    }

    .metric-lbl {
        display: block;
        font-size: 12px;
        font-weight: 600;
        color: #64748b;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Sample Post Box - Exact Seoboss Design */
    .sample-link-card {
        border: 1px dashed #94a3b8;
        border-radius: 12px;
        padding: 25px;
        margin-bottom: 40px;
        background-color: #fff;
    }

    .sample-link-card h4 {
        font-size: 18px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 8px;
    }

    .sample-link-card p {
        font-size: 14px;
        color: #64748b;
        margin-bottom: 18px;
    }

    .view-post-btn {
        background: #7D55A6; 
        color: white;
        padding: 10px 24px;
        border-radius: 30px;
        font-weight: 600;
        font-size: 14px;
        display: inline-flex;
        align-items: center;
        text-decoration: none;
        transition: all 0.3s ease;
        border: none;
    }

    .view-post-btn:hover {
        background: #5EC8D5;
        color: white;
        box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3);
    }

    .sidebar-wrapper {
        position: sticky;
        top: 100px;
    }

    .sidebar-card {
        background: #ffffff;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.03);
        border: 1px solid #f1f5f9;
    }

    .form-group-custom {
        margin-bottom: 18px;
    }

    .form-group-custom label {
        display: block;
        font-size: 13px;
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 8px;
    }

    .input-custom {
        width: 100%;
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 10px;
        padding: 12px 15px;
        font-size: 14px;
        color: #1e293b;
        transition: all 0.2s;
    }

    .input-custom:focus {
        outline: none;
        border-color: var(--rf-teal);
        background: #fff;
    }

    .file-upload-box {
        border: 1px dashed #cbd5e1;
        border-radius: 10px;
        padding: 20px;
        text-align: center;
        background: #f8fafc;
        cursor: pointer;
        transition: all 0.2s;
    }

    .file-upload-box:hover {
        border-color: var(--rf-teal);
        background: #f0f9ff;
    }

    .btn-submit-details {
        width: 100%;
        background:  #7D55A6;
        color: white;
        border: none;
        border-radius: 10px;
        padding: 14px;
        font-weight: 700;
        font-size: 15px;
        transition: all 0.3s;
        box-shadow: 0 4px 15px rgba(71, 193, 216, 0.2);
    }

    .btn-submit-details:hover {
        background: #38b0c5;
        transform: translateY(-2px);
    }

    .checkout-footer {
        background: #1e1b4b; /* RankFetch Purple/Dark */
        border-radius: 20px;
        padding: 25px;
        margin-top: 25px;
        box-shadow: 0 20px 40px rgba(18, 16, 46, 0.2);
    }

    .price-display {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .price-total-lbl {
        color: #94a3b8;
        font-size: 13px;
        font-weight: 500;
    }

    .price-amount {
        color: #ffffff;
        font-size: 28px;
        font-weight: 700;
    }

    .price-original {
        color: #64748b;
        text-decoration: line-through;
        font-size: 18px;
        margin-right: 8px;
    }

    .btn-buy-now {
        width: 100%;
        background: rgba(255,255,255,0.1);
        color: white;
        border: 1px solid rgba(255,255,255,0.15);
        border-radius: 12px;
        padding: 14px;
        font-weight: 600;
        font-size: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        transition: all 0.3s;
        text-decoration: none;
    }

    .btn-buy-now:hover {
        background: rgba(255,255,255,0.2);
        color: white;
    }

    .paypal-box {
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        text-align: center;
    }

    .paypal-badge-text {
        color: #94a3b8;
        font-size: 9px;
        text-transform: uppercase;
        letter-spacing: 1.5px;
        display: block;
        margin-bottom: 12px;
    }

    .paypal-btn-mock {
        background: #f59e0b; 
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 12px;
        cursor: pointer;
        transition: transform 0.2s;
    }
    
    .paypal-btn-mock:hover {
        transform: scale(1.02);
    }

    .section-title-alt {
        font-size: 24px;
        font-weight: 700;
        color: #1e1b4b;
        margin-bottom: 20px;
        font-family: 'Space Grotesk', sans-serif;
    }

    .desc-content {
        color: #475569;
        line-height: 1.8;
        font-size: 15px;
    }
</style>

<div class="space product-details-area">
    <div class="container">
        <div class="row">
            <!-- Left Side -->
            <div class="col-lg-8 pe-lg-5">
                <!-- Breadcrumb -->
                <div class="breadcrumb-custom">
                    <a href="<?php echo e(route('home')); ?>">Home</a>
                    <span class="breadcrumb-separator">/</span>
                    <a href="<?php echo e(route('guest.post')); ?>"><?php echo e($listing->category); ?></a>
                    <span class="breadcrumb-separator">/</span>
                    <span><?php echo e(strtolower($listing->title)); ?></span>
                </div>

                <!-- Title -->
                <h1 class="site-title"><?php echo e(strtolower($listing->title)); ?></h1>

                <!-- Metrics Grid -->
                <div class="metrics-row">
                    <div class="metric-item">
                        <span class="metric-val"><?php echo e($listing->da); ?></span>
                        <span class="metric-lbl">DA</span>
                    </div>
                    <div class="metric-item">
                        <span class="metric-val"><?php echo e($listing->dr); ?></span>
                        <span class="metric-lbl">DR</span>
                    </div>
                    <div class="metric-item">
                        <span class="metric-val"><?php echo e($listing->traffic); ?></span>
                        <span class="metric-lbl">Monthly Traffic</span>
                    </div>
                    <div class="metric-item">
                        <span class="metric-val"><?php echo e($listing->spam_score ?? '1'); ?></span>
                        <span class="metric-lbl">Spam Score</span>
                    </div>
                    <div class="metric-item" style="min-width: 130px;">
                        <span class="metric-val"><?php echo e($listing->link_type ?? 'Dofollow'); ?></span>
                        <span class="metric-lbl">Link</span>
                    </div>
                </div>

                <!-- Sample Post Link (Conditional) -->
                <?php if($listing->sample_post_link): ?>
                <div class="sample-link-card shadow-sm">
                    <h4>Post Sample Link</h4>
                    <p>Check the Sample Post Link before buying to preview the website or domain you're interested in</p>
                    <a href="<?php echo e($listing->sample_post_link); ?>" target="_blank" class="view-post-btn">
                        View Post <i class="fa-solid fa-arrow-right ms-2" style="font-size: 12px;"></i>
                    </a>
                </div>
                <?php endif; ?>

             
            </div>

            <!-- Right Side (Sidebar) -->
            <div class="col-lg-4">
                <div class="sidebar-wrapper">
                    <div class="sidebar-card">
                        <h3 style="font-size: 18px; font-weight: 700; margin-bottom: 25px; color: #1e1b4b;">Submit Details & Proceed to Payment</h3>
                        
                        <?php if(session('success')): ?>
                            <div class="alert alert-success py-2 px-3 mb-3 small" style="border-radius: 10px; background: #ecfdf5; border: 1px solid #10b981; color: #065f46;">
                                <i class="fa-solid fa-check-circle me-1"></i> <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger py-2 px-3 mb-3 small" style="border-radius: 10px; background: #fef2f2; border: 1px solid #ef4444; color: #991b1b;">
                                <ul class="mb-0 list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><i class="fa-solid fa-circle-exclamation me-1"></i> <?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('service.order.process')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="service_type" value="Guest Post">
                            <input type="hidden" name="plan_name" value="<?php echo e($listing->title); ?>">
                            <input type="hidden" name="price" value="<?php echo e($listing->price); ?>">
                            <?php if(request()->query('status') === 'paid'): ?>
                                <input type="hidden" name="payment_status" value="completed">
                                <div class="alert alert-success py-2 px-3 mb-3 small" style="border-radius: 10px; background: #ecfdf5; border: 1px solid #10b981; color: #065f46;">
                                    <i class="fa-solid fa-check-circle me-1"></i> Payment Successful! Fill details below.
                                </div>
                            <?php endif; ?>

                            <div class="form-group-custom">
                                <label>Your Email</label>
                                <input type="email" name="customer_email" class="input-custom" placeholder="example@mail.com" required>
                            </div>
                            
                            <div class="form-group-custom">
                                <label>Website URL</label>
                                <input type="url" name="target_url" class="input-custom" placeholder="https://your-site.com" required>
                            </div>
                            
                            <div class="form-group-custom">
                                <label>Guest Post Topic</label>
                                <input type="text" name="topic" class="input-custom" placeholder="Enter your topic" required>
                            </div>
                            
                            <div class="form-group-custom">
                                <label>WhatsApp Number</label>
                                <input type="text" name="whatsapp_number" class="input-custom" placeholder="+123 456 7890">
                            </div>
                            
                            <div class="form-group-custom">
                                <label>Article File (PDF, Word, etc)</label>
                                <div class="file-upload-box" onclick="document.getElementById('articleFile').click()">
                                    <input type="file" name="article_file" id="articleFile" class="d-none" onchange="updateFileName(this)">
                                    <i class="fa-regular fa-file-lines mb-2" style="font-size: 24px; color: #94a3b8;"></i>
                                    <p id="fileNameDisplay" style="font-size: 12px; color: #94a3b8; margin: 0;">Choose File (PDF, Word, etc)</p>
                                </div>
                            </div>

                            <button type="submit" class="btn-submit-details">
                               <?php echo e(request()->query('status') === 'paid' ? 'Complete My Order' : 'Submit Details & Proceed'); ?>

                            </button>
                        </form>
                    </div>

                    <!-- Checkout Box -->
                    <div class="checkout-footer">
                        <div class="price-display">
                            <span class="price-total-lbl">Total:</span>
                            <div>
                                <?php if($listing->original_price && $listing->original_price > $listing->price): ?>
                                    <span class="price-original">$<?php echo e(number_format($listing->original_price, 0)); ?></span>
                                <?php endif; ?>
                                <span class="price-amount">$<?php echo e(number_format($listing->price, 0)); ?></span>
                            </div>
                        </div>

                        <?php if(request()->query('status') !== 'paid'): ?>
                        <a href="javascript:void(0)" onclick="handlePayFirst()" class="btn-buy-now">
                            Buy Now <i class="fa-solid fa-arrow-right" style="font-size: 12px;"></i>
                        </a>

                        <div class="paypal-box">
                            <span class="paypal-badge-text">Secure payment processing</span>
                            <div class="paypal-btn-mock" onclick="handlePayFirst()">
                                <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/PP_logo_h_100x26.png" alt="PayPal">
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function updateFileName(input) {
        const display = document.getElementById('fileNameDisplay');
        if (input.files.length > 0) {
            display.innerText = input.files[0].name;
            display.style.color = '#7D55A6';
            display.style.fontWeight = 'bold';
        }
    }

    function handlePayFirst() {
        if(confirm('Proceed to PayPal Payment? After payment, you will return to add your guest post details.')) {
            const url = new URL(window.location.href);
            url.searchParams.set('status', 'paid');
            window.location.href = url.toString();
        }
    }
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH C:\xampp\htdocs\Rank-fetch\resources\views/pages/product.blade.php ENDPATH**/ ?>