<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reply from RankFetch</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px;
        }
        .greeting {
            font-size: 18px;
            color: #667eea;
            margin-bottom: 20px;
        }
        .message-box {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .original-message {
            background: #fff;
            border: 1px solid #e0e0e0;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .original-message h3 {
            margin-top: 0;
            color: #666;
            font-size: 14px;
            text-transform: uppercase;
        }
        .footer {
            background: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>RankFetch</h1>
            <p>High-Authority SEO Links & Link Building Services</p>
        </div>
        
        <div class="content">
            <p class="greeting">Hello <?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?>,</p>
            
            <p>Thank you for reaching out to us. We have reviewed your message and here's our response:</p>
            
            <div class="message-box">
                <?php echo nl2br(e($replyMessage)); ?>

            </div>
            
            <div class="original-message">
                <h3>Your Original Message:</h3>
                <p><strong>Subject:</strong> <?php echo e($contact->subject ?? 'N/A'); ?></p>
                <p><strong>Message:</strong></p>
                <p><?php echo e($contact->message); ?></p>
            </div>
            
            <p>If you have any further questions, feel free to reply to this email or visit our website.</p>
            
            <center>
                <a href="<?php echo e(url('/')); ?>" class="button">Visit Our Website</a>
            </center>
        </div>
        
        <div class="footer">
            <p>© <?php echo e(date('Y')); ?> RankFetch. All rights reserved.</p>
            <p>This email was sent in response to your inquiry on our website.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\emails\admin-reply.blade.php ENDPATH**/ ?>