

<?php $__env->startSection('content'); ?>
<div class="mb-8 flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Blog Management</h1>
        <p class="text-gray-500">Manage all your blog posts from one place.</p>
    </div>
    <a href="<?php echo e(route('blog.create')); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white px-6 py-3 rounded-xl font-semibold transition-all shadow-lg shadow-indigo-200 flex items-center">
        <i class="fa-solid fa-plus mr-2"></i> Add New Blog
    </a>
</div>

<?php if(session('success')): ?>
<div class="mb-6 p-4 bg-emerald-50 border-l-4 border-emerald-500 text-emerald-700 rounded-lg shadow-sm flex items-center">
    <i class="fa-solid fa-circle-check mr-3 text-lg"></i>
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full text-left">
            <thead>
                <tr class="bg-gray-50 text-gray-500 text-xs uppercase tracking-wider">
                    <th class="px-6 py-4 font-semibold">ID</th>
                    <th class="px-6 py-4 font-semibold">Blog Detail</th>
                    <th class="px-6 py-4 font-semibold">Status</th>
                    <th class="px-6 py-4 font-semibold text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50 transition-colors">
                    <td class="px-6 py-4 text-gray-500 font-medium">#<?php echo e($blog->id); ?></td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <?php if($blog->image): ?>
                                <img src="<?php echo e(asset($blog->image)); ?>" class="w-16 h-12 object-cover rounded-lg mr-4 shadow-sm border border-gray-100">
                            <?php else: ?>
                                <div class="w-16 h-12 bg-gray-100 rounded-lg mr-4 flex items-center justify-center text-gray-400">
                                    <i class="fa-solid fa-image"></i>
                                </div>
                            <?php endif; ?>
                            <div>
                                <div class="text-sm font-bold text-gray-900"><?php echo e($blog->title); ?></div>
                                <div class="text-xs text-gray-500"><?php echo e($blog->created_at->format('M d, Y')); ?></div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="px-2 py-1 bg-emerald-100 text-emerald-600 text-[10px] rounded font-semibold uppercase">Published</span>
                    </td>
                    <td class="px-6 py-4 text-right space-x-2">
                        <a href="<?php echo e(route('admin.blogs.edit', $blog->id)); ?>" class="inline-flex items-center p-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-100 transition-colors" title="Edit">
                            <i class="fa-solid fa-pen-to-square"></i>
                        </a>

                        <form action="<?php echo e(route('admin.blogs.delete', $blog->id)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="inline-flex items-center p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition-colors" onclick="return confirm('Are you sure you want to delete this blog?')" title="Delete">
                                <i class="fa-solid fa-trash-can"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\admin\blog\blog_index.blade.php ENDPATH**/ ?>