<?php $__env->startSection('title', 'Order Summary | RankFetch'); ?>

<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<style>
    :root {
        --rf-dark: #1e1b4b;
        --rf-teal: #47c1d8;
    }
    .summary-area {
        background-color: #f8fafc;
        padding: 80px 0;
    }
    .summary-card {
        background: #fff;
        border-radius: 24px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.05);
        max-width: 700px;
        margin: 0 auto;
        border: 1px solid #f1f5f9;
    }
    .order-id-badge {
        background: #f1f5f9;
        padding: 5px 15px;
        border-radius: 30px;
        font-size: 12px;
        font-weight: 600;
        color: #64748b;
    }
    .detail-row {
        display: flex;
        justify-content: space-between;
        padding: 12px 0;
        border-bottom: 1px solid #f1f5f9;
    }
    .detail-label {
        font-weight: 600;
        color: #64748b;
        font-size: 14px;
    }
    .detail-val {
        font-weight: 700;
        color: var(--rf-dark);
        font-size: 14px;
    }
    .payment-box {
        background: var(--rf-dark);
        border-radius: 20px;
        padding: 30px;
        margin-top: 30px;
        text-align: center;
        color: #fff;
    }
    .paypal-btn-real {
        background: #ffc439;
        border-radius: 12px;
        padding: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-top: 20px;
        cursor: pointer;
        transition: transform 0.2s;
        text-decoration: none;
        color: #000;
        font-weight: 700;
    }
    .paypal-btn-real:hover {
        transform: scale(1.02);
    }
</style>

<div class="summary-area">
    <div class="container text-center mb-4">
        <div class="icon-circle bg-success text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; border-radius: 50%; font-size: 24px;">
            <i class="fa-solid fa-check"></i>
        </div>
        <h1 class="h2 fw-bold">Order Received!</h1>
        <p class="text-muted">Your order details have been saved. Please complete the payment below.</p>
    </div>

    <div class="summary-card">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="h5 fw-bold mb-0">Order Summary</h3>
            <span class="order-id-badge">Order #RF-<?php echo e(str_pad($order->id, 5, '0', STR_PAD_LEFT)); ?></span>
        </div>

        <div class="detail-row">
            <span class="detail-label">Service</span>
            <span class="detail-val text-uppercase"><?php echo e($order->service_type); ?> Service</span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Plan</span>
            <span class="detail-val"><?php echo e($order->plan_name); ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Email</span>
            <span class="detail-val"><?php echo e($order->customer_email); ?></span>
        </div>
        <div class="detail-row">
            <span class="detail-label">Target URL</span>
            <span class="detail-val"><?php echo e($order->target_url); ?></span>
        </div>
        
        <div class="payment-box">
            <p class="mb-1 text-muted small uppercase">Final Amount to Pay:</p>
            <h2 class="display-5 fw-bold mb-0">$<?php echo e(number_format($order->price, 0)); ?></h2>
            
            <div class="paypal-btn-real" onclick="alert('Proceeding to PayPal... (Sandbox mode enabled)')">
                <img src="https://www.paypalobjects.com/webstatic/en_US/i/buttons/PP_logo_h_100x26.png" alt="PayPal" class="me-2">
                Pay with PayPal
            </div>
            <p class="mt-3 small text-muted">A confirmation email has been sent to <?php echo e($order->customer_email); ?></p>
        </div>
    </div>
</div>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH C:\xampp\htdocs\Rank-fetch\resources\views/pages/service-order-summary.blade.php ENDPATH**/ ?>