

<?php $__env->startSection('content'); ?>
<div class="mb-8 flex justify-between items-center">
    <div>
        <h1 class="text-3xl font-bold text-gray-900"><?php echo e(isset($isGuestPostFilter) ? 'Guest Post Orders' : 'Service Orders'); ?></h1>
        <p class="text-gray-600 mt-1"><?php echo e(isset($isGuestPostFilter) ? 'Manage specifically guest post placement orders.' : 'Manage orders from SEO, Edu, and Niche edit services.'); ?></p>
    </div>
</div>

<div class="glass rounded-2xl shadow-sm border border-gray-200 overflow-hidden">
    <div class="overflow-x-auto">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-gray-50 border-b border-gray-200">
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Order ID</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Customer</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Service/Plan</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Price</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700">Status</th>
                    <th class="px-6 py-4 text-sm font-semibold text-gray-700 text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50/50 transition-colors">
                    <td class="px-6 py-4 font-medium text-indigo-600">
                        #RF-<?php echo e(str_pad($order->id, 5, '0', STR_PAD_LEFT)); ?>

                    </td>
                    <td class="px-6 py-4">
                        <div class="text-sm font-medium text-gray-900"><?php echo e($order->customer_email); ?></div>
                        <div class="text-xs text-gray-500"><?php echo e($order->created_at->format('M d, Y')); ?></div>
                    </td>
                    <td class="px-6 py-4">
                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-blue-50 text-blue-700 uppercase mb-1">
                            <?php echo e($order->service_type); ?>

                        </span>
                        <div class="text-sm text-gray-700"><?php echo e($order->plan_name); ?></div>
                    </td>
                    <td class="px-6 py-4 text-sm font-bold text-gray-900">
                        $<?php echo e(number_format($order->price, 0)); ?>

                    </td>
                    <td class="px-6 py-4">
                        <div class="flex flex-col gap-1">
                            <?php
                                $orderStatusClasses = [
                                    'new' => 'bg-blue-100 text-blue-800',
                                    'processing' => 'bg-yellow-100 text-yellow-800',
                                    'completed' => 'bg-green-100 text-green-800',
                                    'cancelled' => 'bg-red-100 text-red-800',
                                ];
                                $paymentStatusClasses = [
                                    'pending' => 'bg-gray-100 text-gray-800',
                                    'completed' => 'bg-green-100 text-green-800',
                                    'failed' => 'bg-red-100 text-red-800',
                                ];
                            ?>
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($orderStatusClasses[$order->order_status] ?? 'bg-gray-100 text-gray-800'); ?>">
                                Order: <?php echo e(ucfirst($order->order_status)); ?>

                            </span>
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($paymentStatusClasses[$order->payment_status] ?? 'bg-gray-100 text-gray-800'); ?>">
                                Paid: <?php echo e(ucfirst($order->payment_status)); ?>

                            </span>
                        </div>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <a href="<?php echo e(route('admin.orders.show', $order->id)); ?>" class="inline-flex items-center px-3 py-1.5 bg-indigo-50 text-indigo-600 rounded-lg hover:bg-indigo-100 transition-colors text-sm font-medium">
                            <i class="fa-solid fa-eye mr-2"></i> Details
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                        <i class="fa-solid fa-box-open text-4xl mb-4 block"></i>
                        No orders found yet.
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($orders->hasPages()): ?>
    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
        <?php echo e($orders->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dmin\Downloads\Rank-fetch\Rank-fetch\Rank-fetch\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>