

<?php $__env->startSection('content'); ?>
<div class="mb-8">
    <a href="<?php echo e(route('admin.listings.index')); ?>" class="inline-flex items-center text-sm font-medium text-gray-500 hover:text-indigo-600 transition-colors mb-4">
        <i class="fa-solid fa-arrow-left mr-2"></i>
        Back to Inventory
    </a>
    <h1 class="text-3xl font-bold text-gray-900">Add New Website</h1>
    <p class="text-gray-600 mt-1">Add a new website to the guest post marketplace.</p>
</div>

<div class="max-w-4xl">
    <form action="<?php echo e(route('admin.listings.store')); ?>" method="POST" class="space-y-6">
        <?php echo csrf_field(); ?>
        
        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-globe mr-3 text-indigo-500"></i>
                Website Information
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Title -->
                <div class="md:col-span-2">
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Website Title / Domain Name</label>
                    <input type="text" name="title" value="<?php echo e(old('title')); ?>" required placeholder="e.g. Example.com"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- URL -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Website URL (Optional)</label>
                    <input type="text" name="url" value="<?php echo e(old('url')); ?>" placeholder="https://example.com"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Sample Post Link -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Sample Post Link (Optional)</label>
                    <input type="text" name="sample_post_link" value="<?php echo e(old('sample_post_link')); ?>" placeholder="https://example.com/sample-post"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['sample_post_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Category -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Category</label>
                    <input type="text" name="category" value="<?php echo e(old('category')); ?>" required placeholder="e.g. Tech, Health"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Link Type -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Link Type</label>
                    <select name="link_type" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all bg-white">
                        <option value="Dofollow" <?php echo e(old('link_type') == 'Dofollow' ? 'selected' : ''); ?>>Dofollow</option>
                        <option value="Nofollow" <?php echo e(old('link_type') == 'Nofollow' ? 'selected' : ''); ?>>Nofollow</option>
                    </select>
                    <?php $__errorArgs = ['link_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-chart-line mr-3 text-indigo-500"></i>
                SEO Metrics & Pricing
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- DA -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Domain Authority (DA)</label>
                    <input type="number" name="da" value="<?php echo e(old('da')); ?>" required placeholder="0-100" min="0" max="100"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['da'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- DR -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Domain Rating (DR)</label>
                    <input type="number" name="dr" value="<?php echo e(old('dr')); ?>" required placeholder="0-100" min="0" max="100"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['dr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Traffic -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Monthly Traffic</label>
                    <input type="text" name="traffic" value="<?php echo e(old('traffic')); ?>" required placeholder="e.g. 50K+, 1M"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['traffic'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Spam Score -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Spam Score</label>
                    <input type="text" name="spam_score" value="<?php echo e(old('spam_score')); ?>" placeholder="e.g. 1%, N/A"
                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    <?php $__errorArgs = ['spam_score'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Price -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Price ($)</label>
                    <div class="relative">
                        <span class="absolute left-4 top-3.5 text-gray-400">$</span>
                        <input type="number" name="price" value="<?php echo e(old('price')); ?>" required step="0.01" placeholder="0.00"
                            class="w-full pl-8 pr-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    </div>
                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Original Price -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Original Price (For Discount Display)</label>
                    <div class="relative">
                        <span class="absolute left-4 top-3.5 text-gray-400">$</span>
                        <input type="number" name="original_price" value="<?php echo e(old('original_price')); ?>" step="0.01" placeholder="0.00"
                            class="w-full pl-8 pr-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all">
                    </div>
                    <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>

        <div class="glass rounded-2xl p-6 lg:p-8 shadow-sm border border-gray-200">
            <h2 class="text-xl font-bold text-gray-900 mb-6 flex items-center">
                <i class="fa-solid fa-align-left mr-3 text-indigo-500"></i>
                Additional Details
            </h2>
            
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="4" placeholder="Briefly describe the website's audience or niche highlights..."
                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-indigo-500 focus:ring-2 focus:ring-indigo-200 outline-none transition-all"><?php echo e(old('description')); ?></textarea>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-500"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <div class="flex items-center justify-end space-x-4 pt-4">
            <a href="<?php echo e(route('admin.listings.index')); ?>" class="px-6 py-3 text-sm font-semibold text-gray-600 hover:text-gray-900 transition-colors">
                Cancel
            </a>
            <button type="submit" class="inline-flex items-center px-8 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-bold rounded-xl transition-all shadow-lg shadow-indigo-100">
                <i class="fa-solid fa-cloud-arrow-up mr-2"></i>
                Save Website
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH H:\Rank-fetch\Rank-fetch\resources\views\admin\listing\create.blade.php ENDPATH**/ ?>